<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" version="1.0" encoding="utf-8"
		standalone="no" indent="yes" />

	<xsl:template match="/">
		<xsl:processing-instruction name="xml-stylesheet">
			type="text/css" href="exam.css"
		</xsl:processing-instruction>
		<exam>
			<title>
				<examtype>Exam</examtype>
				<coursetitle>
					<xsl:value-of select="/exam/courseid" />
					<xsl:text> </xsl:text>
					<xsl:value-of select="/exam/course" />
				</coursetitle>
				<authors>
					<xsl:for-each
						select="document('questions.xml')/questions/question/author">

						<xsl:choose>
							<xsl:when test="position() = last()">
								<xsl:text> och </xsl:text>
							</xsl:when>
							<xsl:when test="position() &gt; 1">
								<xsl:text>, </xsl:text>
							</xsl:when>
						</xsl:choose>
						<xsl:value-of select="." />
					</xsl:for-each>
				</authors>
				<date>
					<xsl:value-of select="/exam/date" />
				</date>
			</title>

			<document>
				<heading>Instructions</heading>
				<instructions>
					<xsl:value-of select="/exam/instructions" />
				</instructions>

				<heading>Exercises</heading>
				<exercises>
					<xsl:apply-templates
						select="document('questions.xml')/questions" />
				</exercises>
			</document>
		</exam>
	</xsl:template>

	<xsl:template match="questions">
		<xsl:for-each select="question">
			<exercise>
				<points>(<xsl:value-of select="points" />p)</points>
				<number><xsl:value-of select="position()" />.</number>
				<text><xsl:value-of select="text" /></text>
			</exercise>
			<!-- här skriver vi inte ut answer -->
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
