/* 
 * File:   IntArray.h
 * Author: martin
 *
 * Created on March 6, 2013, 9:26 AM
 */

#ifndef INTARRAY_H
#define	INTARRAY_H

class IntArray {
public:
    IntArray(size_t size);
    IntArray(size_t size, int init_value);
    IntArray(const IntArray& orig); // Copy constructor
    ~IntArray();
    
    
    int operator[](int i) const;
    int& operator[](int i);

    IntArray& operator=( const IntArray& rhs ); 

    size_t size() const;
    void resize(size_t size);
    
    void swap(IntArray& rhs);
private:
    IntArray();
    
    int* begin;
    size_t sz;
};

#endif	/* INTARRAY_H */

