/* 
 * File:   IntArray.cpp
 * Author: martin
 * 
 * Created on March 6, 2013, 9:26 AM
 */
#include <algorithm>
#include "IntArray.h"

/** Default constructor. */
IntArray::IntArray() {
}

/** Parametrized contructor
 *  initializing members using : syntax */
IntArray::IntArray(size_t size):sz(size), begin(new int[size]){
    
}
/** Parametrized contructor
 *  initializing members using : syntax
 *  initializing data using for. */
IntArray::IntArray(size_t size, int init_value):sz(size), begin(new int[size]){
    for(size_t i = 0; i < size; i++){
        begin[i]=init_value;
    }
}
/** Copy constructor similar to the above. */
IntArray::IntArray(const IntArray& orig):sz(orig.sz),begin(new int[orig.sz]) {
    for(size_t i = 0; i < sz; i++){
        begin[i]=orig[i];
    }
}
/** Assignment operator, using Copy and Swap idiom.
 * Fault tolerant (exception safe), practical and easy to implement.
 * Other options are trickier to implement and error prone.
 * Please try to implement a "naive" assignment and make sure you avoid 
 * self-assignment. This was thoroughly discussed during the lecture.
 */
IntArray& IntArray::operator=( const IntArray& rhs ){
    IntArray copy(rhs);
    swap(copy);
    return *this;
}

IntArray::~IntArray() {
    delete [] begin;
}

size_t IntArray::size() const{
    return sz;
}

/** The resize operation becomes simple to implement when the 
  constructors and other operations are well implemented.
 */
void IntArray::resize(size_t size){
    IntArray copy(size);
    for( size_t i = 0; i<sz&&i<copy.sz ; i++){
        copy[i] = begin[i];
    }
    swap(copy);
}

/**
 * Mainly for use by the Copy/Swap assignment and resize.
 */
void IntArray::swap(IntArray& rhs){
    std::swap(begin, rhs.begin);
    std::swap(sz, rhs.sz);
}

int IntArray::operator [](int i) const{
    return begin[i];
}
int& IntArray::operator [](int i){
    return begin[i];
}

















