/*
 * Decompiled with CFR 0.152.
 */
package pkg8bitcomputer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import pkg8bitcomputer.Store;

public class RegisterPanel
extends JPanel {
    public static final int COL_WIDTH = 3;
    RegisterModel registerModel;
    private JTable jTable1;

    public RegisterPanel() {
        this.registerModel = new RegisterModel(new Store());
        this.initComponents();
        this.jTable1.getColumn("RX").setCellRenderer(new LabelRenderer());
        this.jTable1.setAutoResizeMode(4);
        this.add("North", this.jTable1.getTableHeader());
    }

    public RegisterPanel(Store store) {
        this.registerModel = new RegisterModel(store);
        this.initComponents();
        this.jTable1.getColumn("RX").setCellRenderer(new LabelRenderer());
        this.jTable1.setAutoResizeMode(4);
        this.add("North", this.jTable1.getTableHeader());
    }

    private void initComponents() {
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(this.registerModel);
        this.add((Component)this.jTable1, "Center");
    }

    class RegisterModel
    extends AbstractTableModel {
        Store store;

        public RegisterModel(Store store) {
            this.store = store;
        }

        @Override
        public int getRowCount() {
            return this.store.register.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                String text = String.format("R%1X", row);
                JLabel registerLabel = new JLabel(text);
                registerLabel.setToolTipText("8 bit register " + text);
                return registerLabel;
            }
            return String.format("%02X", this.store.register[row]);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? JLabel.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "RX" : "XX";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JLabel)value;
        }
    }
}

