/*
 * Decompiled with CFR 0.152.
 */
package pkg8bitcomputer;

public enum OP {
    NOOP(0, "NOOP"),
    LOAD(1, "LOAD"),
    SETR(2, "SETR"),
    STOR(3, "STOR"),
    MOVE(4, "MOVE"),
    ADD(5, "ADD"),
    ADDF(6, "ADDF"),
    OR(7, "OR"),
    AND(8, "AND"),
    XOR(9, "XOR"),
    ROT(10, "ROT"),
    JEQ(11, "JEQ"),
    HLT(12, "HLT"),
    SHL(13, "SHL"),
    SHR(14, "SHR");

    public final String mnemonic;
    public final int opcode;

    private OP(int code, String mnemonic) {
        this.mnemonic = mnemonic;
        this.opcode = code;
    }

    public static OP get(int opcode) {
        return OP.values()[opcode];
    }

    public String toString() {
        return String.format("OPCODE: %1X", this.opcode) + " " + this.mnemonic;
    }
}

