/*
 * Decompiled with CFR 0.152.
 */
package pkg8bitcomputer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.MaskFormatter;
import pkg8bitcomputer.HexCellEditor;
import pkg8bitcomputer.Store;

public class MemoryPanel
extends JPanel {
    private final Store store;
    MemoryModel registerModel;
    private JTable jTable1;

    public MemoryPanel() {
        this.store = new Store();
        this.initComponents();
        this.jTable1.getColumn("  ").setCellRenderer(new LabelRenderer());
        this.jTable1.setAutoResizeMode(4);
        this.add("North", this.jTable1.getTableHeader());
    }

    public MemoryPanel(Store store) {
        this.store = store;
        this.initComponents();
        this.jTable1.getColumn("  ").setCellRenderer(new LabelRenderer());
        this.jTable1.setAutoResizeMode(4);
        this.add("North", this.jTable1.getTableHeader());
        try {
            MaskFormatter maskFormatter = new MaskFormatter("HH");
            maskFormatter.setCommitsOnValidEdit(true);
            maskFormatter.setAllowsInvalid(true);
            JFormattedTextField hexFormattedTextField = new JFormattedTextField(maskFormatter);
            hexFormattedTextField.setValue("00");
            HexCellEditor hexCellEditor = new HexCellEditor(hexFormattedTextField);
            this.jTable1.setDefaultEditor(String.class, hexCellEditor);
        }
        catch (ParseException ex) {
            Logger.getLogger(MemoryPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(new MemoryModel(this.store));
        this.add((Component)this.jTable1, "Center");
    }

    class MemoryModel
    extends AbstractTableModel {
        Store store;

        public MemoryModel(Store store) {
            this.store = store;
        }

        @Override
        public int getRowCount() {
            return this.store.memory.length / 16;
        }

        @Override
        public int getColumnCount() {
            return 1 + this.store.memory.length / 16;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                String text = String.format("%1X0", row);
                JButton memoryRowButton = new JButton(text);
                memoryRowButton.setToolTipText(String.format("Memory, bytes 0x%1X0 - 0x%1XF", row, row));
                memoryRowButton.setBorderPainted(false);
                memoryRowButton.setFocusPainted(false);
                memoryRowButton.setContentAreaFilled(false);
                memoryRowButton.setOpaque(false);
                return memoryRowButton;
            }
            return String.format("%02X", this.store.memory[row * 16 + column - 1]);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? JButton.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "  " : String.format("X%1X", column - 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                this.store.memory[rowIndex * 16 + columnIndex - 1] = Integer.parseInt(aValue.toString(), 16);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(MemoryPanel.class.getName()).log(Level.SEVERE, null, nfe);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    class LabelRenderer
    extends JButton
    implements TableCellRenderer {
        LabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JButton)value;
        }
    }
}

