/*
 * Decompiled with CFR 0.152.
 */
package pkg8bitcomputer;

import com.jtattoo.plaf.noire.NoireLookAndFeel;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import pkg8bitcomputer.ALU;
import pkg8bitcomputer.AboutDialog;
import pkg8bitcomputer.ControlsPanel;
import pkg8bitcomputer.ISAReferenceFrame;
import pkg8bitcomputer.LogPanel;
import pkg8bitcomputer.MemoryPanel;
import pkg8bitcomputer.ProjectFileSelector;
import pkg8bitcomputer.RegisterPanel;
import pkg8bitcomputer.Store;

public class MainFrame
extends JFrame {
    public static final String HEX_BYTE_FMT = "%02X";
    public static final String HEX_FMT = "%1X";
    Store store = new Store();
    ALU alu = new ALU();
    private JMenuItem aboutMenuItem;
    private ControlsPanel controlsPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private LogPanel logPanel;
    private MemoryPanel memoryPanel;
    private JMenuItem openMenuItem;
    private JMenuItem referenceMenuItem;
    private RegisterPanel registerPanel;
    private JMenuItem resetMenuItem;
    private JMenuItem saveMenuItem;
    private JMenu stateMenu;

    public MainFrame() {
        this.initComponents();
        this.controlsPanel.addStepButtonActionListener(e -> this.stepProgram());
        this.controlsPanel.addResetButtonActionListener(e -> this.resetProgramCounter());
        this.controlsPanel.addRunButtonActionListener(e -> this.runProgram());
        SwingUtilities.invokeLater(() -> Thread.currentThread().setUncaughtExceptionHandler((thread, t) -> this.logPanel.addMessage(thread.getName() + "\n" + t.getMessage(), t.getMessage())));
    }

    public void resetProgramCounter() {
        this.store.pc = 0;
        this.controlsPanel.setProgramCounter(this.store.pc);
    }

    public boolean stepProgram() {
        boolean halted = this.alu.execute(this.store);
        this.logPanel.addMessage(this.alu.instructionLog, this.alu.brief);
        this.controlsPanel.setProgramCounter(this.store.pc);
        this.registerPanel.repaint();
        this.memoryPanel.repaint();
        return halted;
    }

    public void runProgram() {
        boolean halted = false;
        while (!halted) {
            halted = this.stepProgram();
        }
    }

    private void initComponents() {
        this.memoryPanel = new MemoryPanel(this.store);
        this.registerPanel = new RegisterPanel(this.store);
        this.controlsPanel = new ControlsPanel();
        this.logPanel = new LogPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.stateMenu = new JMenu();
        this.resetMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.referenceMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("8-bit computer");
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openMenuItem.setText("Open ...");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveMenuItem.setText("Save ...");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.stateMenu.setText("Computer");
        this.resetMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.resetMenuItem.setText("Reset");
        this.resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.resetMenuItemActionPerformed(evt);
            }
        });
        this.stateMenu.add(this.resetMenuItem);
        this.jMenuBar1.add(this.stateMenu);
        this.helpMenu.setText("Help");
        this.referenceMenuItem.setText("ISA reference");
        this.referenceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.referenceMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.referenceMenuItem);
        this.helpMenu.add(this.jSeparator2);
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logPanel, -1, 704, Short.MAX_VALUE).addComponent(this.controlsPanel, -1, 704, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.registerPanel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memoryPanel, -1, 623, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.registerPanel, -2, 292, -2).addComponent(this.memoryPanel, -2, 292, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logPanel, -1, 117, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        ProjectFileSelector pfs = new ProjectFileSelector(this);
        File openFilename = pfs.getOpenFilename();
        if (openFilename == null) {
            return;
        }
        try {
            Scanner hexScanner = new Scanner(openFilename);
            this.store.reset();
            int addr = 0;
            while (hexScanner.hasNextInt(16)) {
                this.store.memory[addr] = hexScanner.nextInt(16);
                ++addr;
            }
            hexScanner.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.resetProgramCounter();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.exit(0);
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        this.store.reset();
        this.memoryPanel.repaint();
        this.registerPanel.repaint();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, true);
        aboutDialog.setVisible(true);
    }

    private void referenceMenuItemActionPerformed(ActionEvent evt) {
        ISAReferenceFrame iasFrame = new ISAReferenceFrame();
        iasFrame.setVisible(true);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        ProjectFileSelector pfs = new ProjectFileSelector(this);
        File saveFilename = pfs.getSaveFilename();
        if (saveFilename == null) {
            return;
        }
        if (!saveFilename.toString().endsWith(".bit")) {
            saveFilename = new File(saveFilename.getAbsoluteFile().toString() + ".bit");
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (int addr = 0; addr < this.store.memory.length; ++addr) {
                sb.append(String.format("%02X ", this.store.memory[addr]));
                if (addr % 16 != 15) continue;
                sb.append("\n");
            }
            try (FileWriter writer = new FileWriter(saveFilename);){
                writer.append(sb);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(NoireLookAndFeel.class.getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new MainFrame().setVisible(true));
    }
}

