/*
 * Decompiled with CFR 0.152.
 */
package pkg8bitcomputer;

import java.text.SimpleDateFormat;
import java.util.Date;
import pkg8bitcomputer.OP;
import pkg8bitcomputer.Store;

public class ALU {
    public String instructionLog;
    public String brief;

    public boolean execute(Store store) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStamp = dateFormat.format(new Date()) + ":\t";
        if (store.pc > 255) {
            this.instructionLog = String.format(timeStamp + ": Program counter overflow", new Object[0]);
            this.brief = String.format("PC overflow", store.pc);
            store.pc = 0;
            return true;
        }
        int instruction = this.fetch(store);
        OP op = OP.get(instruction >> 12);
        int arg1 = (instruction & 0xF00) >> 8;
        int arg2 = (instruction & 0xF0) >> 4;
        int arg3 = instruction & 0xF;
        int addr = instruction & 0xFF;
        switch (op) {
            case NOOP: {
                this.instructionLog = String.format(timeStamp + ": NOOP PC: %02X", store.pc);
                this.brief = String.format("NOOP@%02X", store.pc);
                break;
            }
            case LOAD: {
                this.instructionLog = String.format(timeStamp + ": LOAD R%#X <- %02X (%02X) PC: %02X", arg1, addr, store.memory[addr], store.pc);
                this.brief = String.format("LOAD R%#X %02X@%02X", arg1, addr, store.pc);
                store.register[arg1] = store.memory[addr];
                break;
            }
            case SETR: {
                this.instructionLog = String.format(timeStamp + ": SETR R%#X <- %02X PC: %02X", arg1, addr, store.pc);
                this.brief = String.format("SETR R%#X %02X@%02X", arg1, addr, store.pc);
                store.register[arg1] = addr;
                break;
            }
            case STOR: {
                this.instructionLog = String.format(timeStamp + ": STOR R%#X -> %02X PC: %02X", arg1, addr, store.pc);
                this.brief = String.format("STOR R%#X %02X@%02X", arg1, addr, store.pc);
                store.memory[addr] = store.register[arg1];
                break;
            }
            case MOVE: {
                this.instructionLog = String.format(timeStamp + ": MOVE R%#X(%02X) -> R%#X PC: %02X", arg2, store.register[arg2], arg3, store.pc);
                this.brief = String.format("MOVE R%#X->R%#X@%02X", arg2, arg3, store.pc);
                store.register[arg2] = store.register[arg3];
                break;
            }
            case ADD: {
                store.register[arg1] = 0xFF & store.register[arg2] + store.register[arg3];
                this.instructionLog = String.format(timeStamp + ": ADD R%#X(%02X) + R%#X(%02X) -> R%#X(%02X) PC: %02X", arg2, store.register[arg2], arg3, store.register[arg3], arg1, store.register[arg1], store.pc);
                this.brief = String.format("ADD R%#X+R%#X->R%#X@%02X", arg2, arg3, arg1, store.pc);
                break;
            }
            case ADDF: {
                throw new UnsupportedOperationException("Floating point arithmetic is not implemented in this version.\nLikely never will be.");
            }
            case OR: {
                store.register[arg1] = 0xFF & (store.register[arg2] | store.register[arg3]);
                this.instructionLog = String.format(timeStamp + ": OR R%#X(%02X) R%#X(%02X) -> R%#X(%02X) PC: %02X", arg2, store.register[arg2], arg3, store.register[arg3], arg1, store.register[arg1], store.pc);
                this.brief = String.format("OR R%#X R%#X->R%#X@%02X", arg2, arg3, arg1, store.pc);
                break;
            }
            case AND: {
                store.register[arg1] = 0xFF & (store.register[arg2] & store.register[arg3]);
                this.instructionLog = String.format(timeStamp + ": AND R%#X(%02X) R%#X(%02X) -> R%#X(%02X) PC: %02X", arg2, store.register[arg2], arg3, store.register[arg3], arg1, store.register[arg1], store.pc);
                this.brief = String.format("AND R%#X R%#X->R%#X@%02X", arg2, arg3, arg1, store.pc);
                break;
            }
            case XOR: {
                store.register[arg1] = 0xFF & (store.register[arg2] ^ store.register[arg3]);
                this.instructionLog = String.format(timeStamp + ": XOR R%#X(%02X) R%#X(%02X) -> R%#X(%02X) PC: %02X", arg2, store.register[arg2], arg3, store.register[arg3], arg1, store.register[arg1], store.pc);
                this.brief = String.format("XOR R%#X R%#X->R%#X@%02X", arg2, arg3, arg1, store.pc);
                break;
            }
            case ROT: {
                int rArg1 = store.register[arg1];
                for (int i = 0; i < arg3; ++i) {
                    store.register[arg1] = this.rotRightByte(store.register[arg1]);
                }
                this.instructionLog = String.format(timeStamp + ": ROT R%#X(%02X) x %#X ->  R%#X(%02X) PC: %02X", arg1, rArg1, arg3, arg1, store.register[arg1], store.pc);
                this.brief = String.format("ROT R%#X %#X@%02X", arg1, arg3, store.pc);
                break;
            }
            case JEQ: {
                this.instructionLog = String.format(timeStamp + ": JUMP R%#X(%02X) EQ (%02X) %02X PC: %02X", arg1, store.register[arg1], store.register[0], addr, store.pc);
                this.brief = String.format("JEQ R%#X %02X@%02X", arg1, addr, store.pc);
                if (store.register[arg1] != store.register[0]) break;
                store.pc = addr;
                return false;
            }
            case HLT: {
                this.instructionLog = String.format(timeStamp + ": HLT PC: %02X", store.pc);
                this.brief = String.format("HLT@%02X", store.pc);
                return true;
            }
            case SHL: {
                int lArg1shift = store.register[arg1];
                int msb = store.register[arg1] & 0x80;
                int shift = store.register[arg1] << arg3;
                store.register[arg1] = shift & 0xFF;
                this.instructionLog = String.format(timeStamp + ": SHL R%#X(%02X) %#X (%02X) PC: %02X", arg1, lArg1shift, arg3, store.register[arg1], store.pc);
                this.brief = String.format("SHL R%#X %#X@%02X", arg1, arg3, store.pc);
                break;
            }
            case SHR: {
                int rArg1shift = store.register[arg1];
                int rmsb = store.register[arg1] & 0x80;
                int rshift = store.register[arg1] >> arg3;
                store.register[arg1] = rshift & 0xFF;
                this.instructionLog = String.format(timeStamp + ": SHR R%#X(%02X) %#X (%02X) PC: %02X", arg1, rArg1shift, arg3, store.register[arg1], store.pc);
                this.brief = String.format("SHR R%#X %#X@%02X", arg1, arg3, store.pc);
            }
        }
        store.pc += 2;
        return false;
    }

    private int rotRightByte(int bytevalue) {
        int highBit = (1 & bytevalue) << 7;
        return bytevalue >> 1 | highBit;
    }

    private int fetch(Store store) {
        int op = store.memory[store.pc];
        int operands = store.memory[store.pc + 1];
        return op << 8 | operands & 0xFF;
    }
}

