/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Scanner;
import se.miun.vickar.dt007g.chatserver.ClientHandler;
import se.miun.vickar.dt007g.chatserver.MainServer;
import se.miun.vickar.dt007g.chatserver.messages.FriendMessage;
import se.miun.vickar.dt007g.chatserver.messages.LogoutMessage;
import se.miun.vickar.dt007g.chatserver.messages.Message;
import se.miun.vickar.dt007g.chatserver.messages.ParseError;
import se.miun.vickar.dt007g.chatserver.messages.PrivateMessage;
import se.miun.vickar.dt007g.chatserver.messages.RegisterMessage;

public class Client
implements Runnable {
    private static final Message failed = new PrivateMessage("SERVER", "Unregistered User", "Server failed (>_<)'");
    private ClientHandler myHandler;
    Scanner myScanner;
    private Socket socket;
    private String nickname;
    private String fullName;
    private String image;
    private String ipaddress;
    private File logFile;
    private BufferedWriter fileOut;
    private boolean fileLog;

    public Client(ClientHandler handler, Socket newClient) {
        this.myHandler = handler;
        this.socket = newClient;
        this.fileLog = this.myHandler.getFileLog();
        try {
            this.myScanner = Message.createScanner(this.socket.getInputStream());
            this.startClent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void openLogFile(String nick) {
        if (this.fileLog) {
            this.logFile = new File(String.valueOf(this.myHandler.getLogFolder()) + nick + ".log");
            try {
                this.logFile.createNewFile();
                this.fileOut = new BufferedWriter(new FileWriter(this.logFile, true));
            }
            catch (FileNotFoundException e) {
                this.myHandler.logError(this, "Could not open logfile:" + this.logFile.toString());
                this.fileLog = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.myHandler.logError(this, "Other error opening logfile:" + this.logFile.toString());
                this.fileLog = false;
            }
        }
    }

    private void closeLogFile() {
        try {
            this.fileOut.close();
        }
        catch (IOException e) {
            this.myHandler.logError(this, "Could not close logfile:" + this.logFile.toString());
        }
    }

    private void startClent() {
        Message reply = failed;
        try {
            Message message = Message.parseMessage(this.myScanner);
            if (message != null && message.getType() == 1) {
                RegisterMessage loginMessage = (RegisterMessage)message;
                this.setFullName(loginMessage.getFullName());
                this.setNickname(loginMessage.getNickname());
                this.setIpaddress(loginMessage.getIpaddress());
                this.setImage(loginMessage.getImage());
                if (this.myHandler.registerClient(loginMessage.getNickname(), this)) {
                    this.log("Client connected");
                    reply = new PrivateMessage("SERVER", loginMessage.getNickname(), "Welcome online " + loginMessage.getFullName() + ". You are accessing this server from " + this.socket.getInetAddress().toString() + " and say you are from " + loginMessage.getIpaddress() + ". Announcing your pressence in the public room now. ");
                    this.sendMessage(reply);
                    this.myHandler.addToExecutor(this);
                } else {
                    reply = new PrivateMessage("SERVER", loginMessage.getNickname(), "Nickname" + loginMessage.getNickname() + " is allready present, please register a unique name");
                    this.sendMessage(reply);
                    this.closeSocket();
                }
            } else if (message != null) {
                reply = new PrivateMessage("SERVER", "Unregistered User", "Please register before performing any other signalling");
                this.sendMessage(reply);
                this.closeSocket();
            } else if (this.socket.getInputStream().available() > 0) {
                byte[] buffer = new byte[64];
                int read = this.socket.getInputStream().read(buffer);
                reply = new PrivateMessage("SERVER", "Unregistered User", "Server failed to parse your message, this is not parsed: " + new String(buffer, 0, read));
                this.sendMessage(reply);
                this.closeSocket();
            } else {
                reply = new PrivateMessage("SERVER", "Unregistered User", "Server failed, ask teacher to check logs at: " + new Date().toString());
                this.sendMessage(reply);
                this.closeSocket();
            }
        }
        catch (IOException e) {
            this.closeSocket();
        }
        catch (ParseError error) {
            PrivateMessage message = new PrivateMessage("SERVER", "USER", "Failed client login due to: " + error.getMessage());
            this.sendMessage(message);
            this.closeSocket();
        }
    }

    private void closeSocket() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.myScanner.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.myHandler.logError(this, "Failed to close socket in Client, client not registered");
        }
    }

    public void sendMessage(Message message) {
        String msg = message.toString();
        this.log("Sending " + msg);
        byte[] data = msg.getBytes(Message.charset);
        if (!this.socket.isOutputShutdown()) {
            try {
                this.socket.getOutputStream().write(data);
                this.socket.getOutputStream().flush();
            }
            catch (IOException e) {
                this.myHandler.unRegisterClient(this.getNickname());
                this.myScanner.close();
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.myHandler.recordStatistics("DATA", data.length);
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public String getImage() {
        return this.image;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public void shutdown() {
        PrivateMessage pMsg = new PrivateMessage("SERVER", this.getNickname(), "The server is shutting down");
        this.sendMessage(pMsg);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.myScanner.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeLogFile();
    }

    @Override
    public void run() {
        block10: while (!this.socket.isClosed()) {
            PrivateMessage reply;
            try {
                Message message = Message.parseMessage(this.myScanner, true);
                if (message == null) continue;
                this.log("Recieved message: " + message.toString());
                switch (message.getType()) {
                    case 3: {
                        reply = new PrivateMessage("SERVER", this.getNickname(), "The chat server should never recieve this type of message from a client");
                        this.sendMessage(reply);
                        break;
                    }
                    case 5: {
                        LogoutMessage msg = (LogoutMessage)message;
                        if (msg.getNickname().equalsIgnoreCase(this.getNickname())) {
                            this.myHandler.unRegisterClient(this.getNickname());
                            this.myScanner.close();
                            this.socket.close();
                            break;
                        }
                        new PrivateMessage("SERVER", this.getNickname(), "You are not allowed to log out someone else. GOOD BYE!");
                        this.myHandler.unRegisterClient(this.getNickname());
                        this.myScanner.close();
                        this.socket.close();
                        break;
                    }
                    case 4: {
                        PrivateMessage pMsg = (PrivateMessage)message;
                        this.myHandler.sendTo(pMsg.getFriendnickname(), pMsg);
                        break;
                    }
                    case 2: {
                        this.myHandler.sendToAllExcept(this.getNickname(), message);
                        break;
                    }
                    case 1: {
                        RegisterMessage rMsg = (RegisterMessage)message;
                        if (!rMsg.getNickname().equalsIgnoreCase(this.getNickname())) continue block10;
                        this.setFullName(rMsg.getFullName());
                        this.setImage(rMsg.getImage());
                        this.setIpaddress(rMsg.getIpaddress());
                        PrivateMessage reply1 = new PrivateMessage("SERVER", this.getNickname(), "Server updated with new information");
                        this.sendMessage(reply1);
                        this.myHandler.sendToAllExcept(this.getNickname(), new FriendMessage(this.getNickname(), this.getFullName(), this.getIpaddress(), this.getImage()));
                        break;
                    }
                }
            }
            catch (ParseError e) {
                reply = new PrivateMessage("SERVER", this.getNickname(), "Server message parse error: " + e.getMessage());
                this.sendMessage(reply);
            }
            catch (IOException e) {
                this.closeSocket();
                this.myHandler.unRegisterClient(this.getNickname());
            }
        }
    }

    public String getSocketInetAddress() {
        return this.socket.getInetAddress().getCanonicalHostName();
    }

    public void log(String string) {
        if (this.fileOut == null) {
            System.err.println("Error in writing logfile:" + this.logFile.toString());
        }
        if (this.fileLog) {
            try {
                this.fileOut.write(String.valueOf(MainServer.PerThreadLogFormatter.getDateFormatter().format(new Date())) + ":" + string);
                this.fileOut.newLine();
                this.fileOut.flush();
            }
            catch (IOException e) {
                this.fileLog = false;
                System.err.println("Error in writing logfile:" + this.logFile.toString());
            }
        }
    }

    public void startLog(String nick) {
        this.openLogFile(nick);
    }

    public String toString() {
        return "Nickname: " + this.nickname + " Full Name: " + this.fullName + ", image: " + this.image;
    }
}

