/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver.messages;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Scanner;
import se.miun.vickar.dt007g.chatserver.messages.FriendMessage;
import se.miun.vickar.dt007g.chatserver.messages.LogoutMessage;
import se.miun.vickar.dt007g.chatserver.messages.ParseError;
import se.miun.vickar.dt007g.chatserver.messages.PrivateMessage;
import se.miun.vickar.dt007g.chatserver.messages.PublicMessage;
import se.miun.vickar.dt007g.chatserver.messages.RegisterMessage;

public abstract class Message {
    public static final int MESSAGE_TYPE_REGISTER = 1;
    public static final int MESSAGE_TYPE_PUBLIC = 2;
    public static final int MESSAGE_TYPE_FRIEND = 3;
    public static final int MESSAGE_TYPE_PRIVATE = 4;
    public static final int MESSAGE_TYPE_LOGOUT = 5;
    private static final String MESSAGE_REGEX_DELIMITER = "[<>]+";
    public static final Charset charset = Charset.forName("UTF8");
    private String nickname;

    public static Scanner createScanner(InputStream in) {
        Scanner sc = new Scanner((InputStream)new DataInputStream(in), charset.name());
        sc.useDelimiter(MESSAGE_REGEX_DELIMITER);
        return sc;
    }

    public static Scanner createScanner(String in) {
        Scanner sc = new Scanner(in);
        sc.useDelimiter(MESSAGE_REGEX_DELIMITER);
        return sc;
    }

    public static Message parseMessage(Scanner sc) throws ParseError, IOException {
        return Message.parseMessage(sc, false);
    }

    /*
     * Exception decompiling
     */
    public static Message parseMessage(Scanner sc, boolean asServer) throws ParseError, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl49 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl49 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String readToken(Scanner sc) throws ParseError {
        try {
            String text = sc.next();
            if (text.endsWith(">")) {
                text = text.replace(">", "");
            }
            return text;
        }
        catch (NoSuchElementException noSuchElementException) {
            return "";
        }
    }

    public static Message parseRegisterMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("REGISTER")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String fullName = text;
        if (fullName == "") {
            throw new ParseError("Couldn't read FULLNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String ipaddress = text;
        if (ipaddress == "") {
            throw new ParseError("Couldn't read IPADDRESS or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String image = text;
        if (image == "") {
            throw new ParseError("Couldn't read IMAGE or it is missing the closing bracket \">\"");
        }
        return new RegisterMessage(nickname, fullName, ipaddress, image);
    }

    private static Message parseFriendMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("FRIEND")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String fullName = text;
        if (fullName == "") {
            throw new ParseError("Couldn't read FULLNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String ipaddress = text;
        if (ipaddress == "") {
            throw new ParseError("Couldn't read IPADDRESS or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String image = text;
        if (image == "") {
            throw new ParseError("Couldn't read IMAGE or it is missing the closing bracket \">\"");
        }
        return new FriendMessage(nickname, fullName, ipaddress, image);
    }

    private static Message parseLogoutMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("LOGOUT")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        return new LogoutMessage(nickname);
    }

    private static Message parsePrivateMessage(Scanner sc, boolean asServer) throws ParseError {
        String friendnickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("PRIVATE")) {
            text = Message.readToken(sc);
        }
        String yournickname = text;
        if (asServer) {
            if (yournickname == "") {
                throw new ParseError("Couldn't read YOURNICKNAME or it is missing the closing bracket \">\"");
            }
            text = Message.readToken(sc);
        }
        if ((friendnickname = text) == "") {
            throw new ParseError("Couldn't read FRIENDSNICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String messagetext = text;
        if (messagetext == "") {
            throw new ParseError("Couldn't read MESSAGE or it is missing the closing bracket \">\"");
        }
        return new PrivateMessage(yournickname, friendnickname, messagetext);
    }

    private static Message parsePublicMessage(Scanner sc) throws ParseError {
        String yournickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("PUBLIC")) {
            text = Message.readToken(sc);
        }
        if ((yournickname = text) == "") {
            throw new ParseError("Couldn't read YOURNICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String messagetext = text;
        if (messagetext == "") {
            throw new ParseError("Couldn't read MESSAGE or it is missing the closing bracket \">\"");
        }
        return new PublicMessage(yournickname, messagetext);
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public abstract int getType();

    public abstract String sendToServer();

    public abstract String toString();
}

