/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class DisplayServer
extends Thread {
    ServerSocket ss;
    String httpStart = "HTTP/1.1 200 OK\nContent-Type: text/html; charset=UTF-8\nConnection: close\nContent-Length: ";
    private DisplayProvider provider;

    public DisplayServer(int port, DisplayProvider provider) {
        this.provider = provider;
        while (port < 65536) {
            try {
                this.ss = new ServerSocket(port++);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.ss.getLocalPort();
    }

    @Override
    public String toString() {
        return "DisplayServer running on:" + this.ss.getLocalPort();
    }

    public void shutdown() {
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.provider.runDisplayServer()) {
            try {
                Socket s = this.ss.accept();
                HandleConnectionThread t = new HandleConnectionThread(s);
                t.start();
            }
            catch (SocketException e) {
                if (e.getMessage().contains("socket closed")) continue;
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface DisplayProvider {
        public boolean runDisplayServer();

        public void updateOutputString();

        public String getOutputString();
    }

    private class HandleConnectionThread
    extends Thread {
        Socket s;

        public HandleConnectionThread(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                DisplayServer.this.provider.updateOutputString();
                StringBuilder finalString = new StringBuilder().append(DisplayServer.this.httpStart).append(DisplayServer.this.provider.getOutputString().length()).append("\n\n").append(DisplayServer.this.provider.getOutputString());
                OutputStream os = this.s.getOutputStream();
                os.write(finalString.toString().getBytes());
                os.flush();
                Thread.sleep(500L);
                os.close();
                this.s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

