/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatclient;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Scanner;
import se.miun.vickar.dt007g.chatclient.ChatClientErrorListener;
import se.miun.vickar.dt007g.chatclient.MessageHandler;
import se.miun.vickar.dt007g.chatserver.messages.FriendMessage;
import se.miun.vickar.dt007g.chatserver.messages.LogoutMessage;
import se.miun.vickar.dt007g.chatserver.messages.Message;
import se.miun.vickar.dt007g.chatserver.messages.ParseError;
import se.miun.vickar.dt007g.chatserver.messages.PrivateMessage;
import se.miun.vickar.dt007g.chatserver.messages.PublicMessage;
import se.miun.vickar.dt007g.chatserver.messages.RegisterMessage;

public class ChatClient
implements Runnable {
    public static String SERVER_IP = "127.0.0.1";
    public static int SERVER_PORT = 8000;
    private ChatClientErrorListener errorListener;
    private MessageHandler messageHandler;
    private String nick;
    private String name;
    private String image;
    private String ipaddress;
    private Socket socket;
    private String lastError;
    private Thread thread;
    private Scanner myScanner;

    public ChatClient(String nick, String name, String image) {
        this.setNick(nick);
        this.setName(name);
        this.setImage(image);
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("Enter nickname:");
        String nick = sc.nextLine();
        System.out.println("Enter full name:");
        String name = sc.nextLine();
        String image = "N/A";
        ChatClient client = new ChatClient(nick, name, image);
        client.setErrorListener(null);
        client.setMessageHandler(new MessageHandler(){

            @Override
            public void newPublicMessage(String nickname, String messagetext) {
                System.out.println(String.valueOf(nickname) + ": " + messagetext);
            }

            @Override
            public void newPrivateMessage(String nickname, String messagetext) {
                System.out.println("From " + nickname + ": " + messagetext);
            }

            @Override
            public void newFriend(String nickname, String fullName, String ipaddress, String image) {
                System.out.println("User joined: " + nickname);
            }

            @Override
            public void logout(String nickname) {
                System.out.println("User left: " + nickname);
            }
        });
        if (!client.login()) {
            System.err.println(client.getLatestError());
        }
        do {
            String message;
            String to;
            String in;
            if ((in = sc.nextLine()).startsWith("@\"")) {
                to = in.substring(2, in.indexOf(34, 2));
                message = in.substring(in.indexOf(34, 2) + 1);
                client.sendPrivateMessage(to, message.trim());
                continue;
            }
            if (in.startsWith("@")) {
                to = in.substring(1, in.indexOf(32));
                message = in.substring(in.indexOf(32));
                client.sendPrivateMessage(to, message.trim());
                continue;
            }
            if (in.contentEquals("QUIT")) {
                client.logout();
                continue;
            }
            client.sendPublicMessage(in);
        } while (client.isConnected());
    }

    public void sendPublicMessage(String in) {
        if (in.isEmpty()) {
            return;
        }
        PublicMessage pm = new PublicMessage(this.getNick(), in);
        this.SendMessage(pm.sendToServer());
    }

    public void sendPrivateMessage(String to, String message) {
        if (message.isEmpty()) {
            return;
        }
        PrivateMessage pm = new PrivateMessage(this.getNick(), to, message);
        this.SendMessage(pm.sendToServer());
    }

    public boolean isConnected() {
        return !this.socket.isClosed();
    }

    public String getLatestError() {
        return this.lastError;
    }

    public boolean login() {
        try {
            this.socket = new Socket(SERVER_IP, SERVER_PORT);
            RegisterMessage msg = new RegisterMessage(this.getNick(), this.getName(), this.socket.getInetAddress().getHostAddress(), this.getImage());
            this.SendMessage(((Message)msg).sendToServer());
            this.startMainThread();
            return true;
        }
        catch (UnknownHostException e) {
            this.error(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.error(e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    private void startMainThread() {
        this.thread = new Thread((Runnable)this, "Message receiver");
        this.thread.start();
    }

    public void logout() {
        LogoutMessage lm = new LogoutMessage(this.getNick());
        this.SendMessage(lm.sendToServer());
        try {
            this.myScanner.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void error(String message) {
        this.lastError = message;
    }

    private void SendMessage(String sendToServer) {
        System.out.println("Sending " + sendToServer);
        try {
            this.socket.getOutputStream().write(sendToServer.getBytes(Message.charset));
        }
        catch (IOException e) {
            this.error("Server connection error");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setErrorListener(ChatClientErrorListener object) {
        this.errorListener = object;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    public void run() {
        this.myScanner = null;
        try {
            this.myScanner = Message.createScanner(this.socket.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-2);
        }
        block11: while (this.isConnected()) {
            try {
                Message message = Message.parseMessage(this.myScanner);
                if (message == null) continue;
                switch (message.getType()) {
                    case 3: {
                        FriendMessage fm = (FriendMessage)message;
                        if (this.messageHandler == null) continue block11;
                        this.messageHandler.newFriend(fm.getNickname(), fm.getFullName(), fm.getIpaddress(), fm.getImage());
                        break;
                    }
                    case 5: {
                        LogoutMessage msg = (LogoutMessage)message;
                        if (this.messageHandler == null) continue block11;
                        this.messageHandler.logout(msg.getNickname());
                        break;
                    }
                    case 4: {
                        PrivateMessage pMsg = (PrivateMessage)message;
                        if (this.messageHandler == null) continue block11;
                        this.messageHandler.newPrivateMessage(pMsg.getNickname(), pMsg.getMessagetext());
                        break;
                    }
                    case 2: {
                        PublicMessage pm = (PublicMessage)message;
                        if (this.messageHandler == null) continue block11;
                        this.messageHandler.newPublicMessage(pm.getNickname(), pm.getMessagetext());
                        break;
                    }
                }
            }
            catch (ParseError e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-3);
            }
        }
    }
}

