/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver.messages;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Scanner;
import se.miun.vickar.dt007g.chatserver.messages.FriendMessage;
import se.miun.vickar.dt007g.chatserver.messages.LogoutMessage;
import se.miun.vickar.dt007g.chatserver.messages.ParseError;
import se.miun.vickar.dt007g.chatserver.messages.PrivateMessage;
import se.miun.vickar.dt007g.chatserver.messages.PublicMessage;
import se.miun.vickar.dt007g.chatserver.messages.RegisterMessage;

public abstract class Message {
    public static final int MESSAGE_TYPE_PARSEERROR = -1;
    public static final int MESSAGE_TYPE_REGISTER = 1;
    public static final int MESSAGE_TYPE_PUBLIC = 2;
    public static final int MESSAGE_TYPE_FRIEND = 3;
    public static final int MESSAGE_TYPE_PRIVATE = 4;
    public static final int MESSAGE_TYPE_LOGOUT = 5;
    private static final String MESSAGE_REGEX_DELIMITER = "[<>]+";
    public static final Charset charset = Charset.forName("UTF8");
    private String nickname;

    public static Scanner createScanner(InputStream in) {
        Scanner sc = new Scanner((InputStream)new DataInputStream(in), charset.name());
        sc.useDelimiter(MESSAGE_REGEX_DELIMITER);
        return sc;
    }

    public static Scanner createScanner(String in) {
        Scanner sc = new Scanner(in);
        sc.useDelimiter(MESSAGE_REGEX_DELIMITER);
        return sc;
    }

    public static Message parseMessage(Scanner sc) throws ParseError, IOException {
        return Message.parseMessage(sc, false);
    }

    public static Message parseMessage(Scanner sc, boolean asServer) throws ParseError, IOException {
        String text = Message.readToken(sc);
        if (text.equals("LOGOUT")) {
            return Message.parseLogoutMessage(sc);
        }
        if (text.equals("PUBLIC")) {
            return Message.parsePublicMessage(sc);
        }
        if (text.equals("REGISTER")) {
            return Message.parseRegisterMessage(sc);
        }
        if (text.equals("PRIVATE")) {
            return Message.parsePrivateMessage(sc, asServer);
        }
        if (text.equals("FRIEND")) {
            return Message.parseFriendMessage(sc);
        }
        return null;
    }

    static String readToken(Scanner sc) throws ParseError {
        try {
            String text = sc.next();
            if (text.endsWith(">")) {
                // empty if block
            }
            return text.replace(">", "");
        }
        catch (NoSuchElementException noSuchElementException) {
            return "";
        }
    }

    public static Message parseRegisterMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("REGISTER")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String fullName = text;
        if (fullName == "") {
            throw new ParseError("Couldn't read FULLNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String ipaddress = text;
        if (ipaddress == "") {
            throw new ParseError("Couldn't read IPADDRESS or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String image = text;
        if (image == "") {
            throw new ParseError("Couldn't read IMAGE or it is missing the closing bracket \">\"");
        }
        return new RegisterMessage(nickname, fullName, ipaddress, image);
    }

    private static Message parseFriendMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("FRIEND")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String fullName = text;
        if (fullName == "") {
            throw new ParseError("Couldn't read FULLNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String ipaddress = text;
        if (ipaddress == "") {
            throw new ParseError("Couldn't read IPADDRESS or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String image = text;
        if (image == "") {
            throw new ParseError("Couldn't read IMAGE or it is missing the closing bracket \">\"");
        }
        return new FriendMessage(nickname, fullName, ipaddress, image);
    }

    private static Message parseLogoutMessage(Scanner sc) throws ParseError {
        String nickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("LOGOUT")) {
            text = Message.readToken(sc);
        }
        if ((nickname = text) == "") {
            throw new ParseError("Couldn't read NICKNAME or it is missing the closing bracket \">\"");
        }
        return new LogoutMessage(nickname);
    }

    private static Message parsePrivateMessage(Scanner sc, boolean asServer) throws ParseError {
        String friendnickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("PRIVATE")) {
            text = Message.readToken(sc);
        }
        String yournickname = text;
        if (asServer) {
            if (yournickname == "") {
                throw new ParseError("Couldn't read YOURNICKNAME or it is missing the closing bracket \">\"");
            }
            text = Message.readToken(sc);
        }
        if ((friendnickname = text) == "") {
            throw new ParseError("Couldn't read FRIENDSNICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String messagetext = text;
        if (messagetext == "") {
            throw new ParseError("Couldn't read MESSAGE or it is missing the closing bracket \">\"");
        }
        return new PrivateMessage(yournickname, friendnickname, messagetext);
    }

    private static Message parsePublicMessage(Scanner sc) throws ParseError {
        String yournickname;
        String text = Message.readToken(sc);
        if (text.contentEquals("PUBLIC")) {
            text = Message.readToken(sc);
        }
        if ((yournickname = text) == "") {
            throw new ParseError("Couldn't read YOURNICKNAME or it is missing the closing bracket \">\"");
        }
        text = Message.readToken(sc);
        String messagetext = text;
        if (messagetext == "") {
            throw new ParseError("Couldn't read MESSAGE or it is missing the closing bracket \">\"");
        }
        return new PublicMessage(yournickname, messagetext);
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public abstract int getType();

    public abstract String sendToServer();

    public abstract String toString();
}

