/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import se.miun.vickar.dt007g.chatserver.Client;
import se.miun.vickar.dt007g.chatserver.ClientHandler;
import se.miun.vickar.dt007g.chatserver.DisplayServer;
import se.miun.vickar.dt007g.chatserver.commandParser;
import se.miun.vickar.dt007g.chatserver.messages.FriendMessage;
import se.miun.vickar.dt007g.chatserver.messages.LogoutMessage;
import se.miun.vickar.dt007g.chatserver.messages.Message;
import se.miun.vickar.dt007g.chatserver.messages.PrivateMessage;

public class MainServer
implements Runnable,
DisplayServer.DisplayProvider {
    private static final int DEFAULT_SERVERPORT = 8000;
    private static final String DEFAULT_LOG_FOLDER = "." + File.separator + "logs" + File.separator;
    private boolean running;
    private ServerSocket mainSocket;
    private boolean debug = false;
    private boolean fileLog = false;
    private File logFile;
    private BufferedWriter fileOut;
    private Date start;
    SSLServerSocketFactory ssocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
    final String[] enabledCipherSuites = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
    private int serverPort;
    private ExecutorService threadPool;
    private ClientHandlerImpl clientHandler;
    private MainServerCommander serverCommander;
    private DisplayServer ds;
    private String outputString;
    private long lastUpdate = 0L;
    private long dataRead = 0L;
    String htmlStart = "<!DOCTYPE html>\n<html>\n\t<head>\n\t\t<title>DT007g Chat Server Status</title>\n\t</head>\n\t<body>\n";
    String htmlEnd = "\n\t</body>\n</html>";

    public static void main(String[] args) {
        MainServer mainServer = new MainServer(8000, true);
        try {
            mainServer.start();
        }
        catch (IOException e) {
            System.err.println("Server error: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Server started, enter anything to exit");
        try {
            int n = System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mainServer.stop();
    }

    private ServerSocket createSSLServerSocket() throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)this.ssocketFactory.createServerSocket(8001);
        serverSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        return serverSocket;
    }

    public MainServer() {
        this(8000);
    }

    public MainServer(int port) {
        this(port, false);
    }

    public MainServer(int port, boolean logging) {
        this.fileLog = logging;
        this.serverPort = port;
        this.ds = new DisplayServer(this.serverPort + 2, this);
        System.out.println("Display Server:" + this.ds.toString());
        this.threadPool = Executors.newCachedThreadPool();
        this.clientHandler = new ClientHandlerImpl();
        this.serverCommander = new MainServerCommander();
        if (this.fileLog) {
            if (!new File(DEFAULT_LOG_FOLDER).exists()) {
                Path dir = Paths.get(DEFAULT_LOG_FOLDER, new String[0]);
                try {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.err.println("Could not create log folder:" + DEFAULT_LOG_FOLDER);
                }
            }
            Date date = new Date();
            DateFormat dateFormat = PerThreadLogFormatter.PerThreadFileNameFormatter.getDateFormatter();
            this.logFile = new File(DEFAULT_LOG_FOLDER + "ChatServer_" + dateFormat.format(date) + ".txt");
            try {
                this.fileOut = new BufferedWriter(new FileWriter(this.logFile));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not open logFile:" + this.logFile.toString());
                this.fileLog = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Other error opening logFile:" + this.logFile.toString());
                this.fileLog = false;
            }
        }
    }

    private void start() throws IOException {
        this.start = new Date();
        this.mainSocket = new ServerSocket(this.serverPort);
        this.ds.start();
        this.running = true;
        this.threadPool.execute(this);
        this.log("Server started, listening to" + this.mainSocket.getInetAddress().getCanonicalHostName());
        System.out.println("Server started, listening to " + this.mainSocket.getInetAddress().getCanonicalHostName() + ":" + this.mainSocket.getLocalPort());
    }

    private void stop() {
        System.out.println("Performing an orderly shutdown of the server");
        this.log("Performing an orderly shutdown of the server");
        this.running = false;
        try {
            this.mainSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Shutting down clients");
        this.log("Shutting down clients");
        this.clientHandler.shutdownClients();
        this.ds.shutdown();
        this.threadPool.shutdown();
        System.out.println("Awating client termination");
        this.log("Awating client termination");
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Cleaning up remanining treads");
        this.log("Cleaning up remanining treads");
        List<Runnable> result = this.threadPool.shutdownNow();
        if (result.size() > 0) {
            System.out.println(result.size() + " threads were awaiting execution.");
            System.out.println(result.size() + " threads were awaiting execution.");
        }
        System.out.println("Shutdown complete.");
        this.log("Shutdown complete.");
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket newClient = this.mainSocket.accept();
                this.handleNewClient(newClient);
            }
            catch (IOException e) {
                if (!this.running) continue;
                System.out.println("Error accepting sockets due to:" + e.getMessage());
            }
        }
    }

    private void handleNewClient(final Socket newClient) {
        ClientInstantiator client = new ClientInstantiator(newClient);
        final Future<?> result = this.threadPool.submit(client);
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    result.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    PrivateMessage pMsg = new PrivateMessage("SERVER", "CLIENT", "Connection timed out, check REGISTER message syntax");
                    try {
                        newClient.getOutputStream().write(pMsg.toString().getBytes(Message.charset));
                        newClient.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void log(String string) {
        if (this.debug) {
            System.out.println("[ChatServer " + PerThreadLogFormatter.getDateFormatter().format(new Date()) + "]\n" + string);
        }
        if (this.fileLog) {
            try {
                this.fileOut.write(PerThreadLogFormatter.getDateFormatter().format(new Date()) + ":" + string);
                this.fileOut.newLine();
                this.fileOut.flush();
            }
            catch (IOException e) {
                this.fileLog = false;
                System.err.println("Error in writing logfile:" + this.logFile.toString());
            }
        }
    }

    public synchronized void incrementData(int value) {
        this.dataRead += (long)value;
    }

    @Override
    public boolean runDisplayServer() {
        return this.running;
    }

    @Override
    public synchronized void updateOutputString() {
        if (System.currentTimeMillis() - this.lastUpdate < 2000L) {
            return;
        }
        long diffInSeconds = (new Date().getTime() - this.start.getTime()) / 1000L;
        this.lastUpdate = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlStart);
        sb.append("\t\tChat Server is ONLINE<br />\n");
        sb.append("\t\t<p>There are currently " + this.clientHandler.size() + " clients </p>\n\t\t<p>\n\t\t\t");
        for (Client client : this.clientHandler.map.values()) {
            sb.append(this.convertToHTML(client.toString())).append("<br />\n\t\t\t");
        }
        sb.append("\n\t\t</p>\n\t\t<p>\n");
        sb.append("\t\t\tUptime: ").append(this.getUptime()).append("<br />\n");
        sb.append("\t\t\tData handled: ").append(this.dataRead).append("<br />\n");
        if (diffInSeconds > 0L) {
            sb.append("\t\t\taverage throughput: ").append(this.dataRead / diffInSeconds).append("<br />\n");
        }
        sb.append("\t\t\tFor more information visit: <a href=\"http://w3.miun.se/dt007g\">The Course Website</a>").append("<br />\n");
        sb.append(this.htmlEnd);
        this.outputString = sb.toString();
    }

    @Override
    public String getOutputString() {
        return this.outputString;
    }

    private String convertToHTML(String input) {
        return input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;");
    }

    private String getUptime() {
        long diffInSeconds = (new Date().getTime() - this.start.getTime()) / 1000L;
        long[] diff = new long[4];
        diff[3] = diffInSeconds >= 60L ? diffInSeconds % 60L : diffInSeconds;
        diffInSeconds /= diffInSeconds % 60L;
        diff[2] = diffInSeconds;
        diffInSeconds /= diffInSeconds % 24L;
        diff[1] = diffInSeconds;
        diff[0] = diffInSeconds /= 24L;
        if (diff[0] > 0L) {
            return String.format("%d day%s, %d hour%s, %d minute%s, %d second%s ago", diff[0], diff[0] > 1L ? "s" : "", diff[1], diff[1] > 1L ? "s" : "", diff[2], diff[2] > 1L ? "s" : "", diff[3], diff[3] > 1L ? "s" : "");
        }
        if (diff[1] > 0L) {
            return String.format("%d hour%s, %d minute%s, %d second%s ago", diff[1], diff[1] > 1L ? "s" : "", diff[2], diff[2] > 1L ? "s" : "", diff[3], diff[3] > 1L ? "s" : "");
        }
        if (diff[2] > 0L) {
            return String.format("%d minute%s, %d second%s ago", diff[2], diff[2] > 1L ? "s" : "", diff[3], diff[3] > 1L ? "s" : "");
        }
        return String.format("%d second%s ago", diff[3], diff[3] > 1L ? "s" : "");
    }

    static class PerThreadLogFormatter {
        private static final ThreadLocal<SimpleDateFormat> dateFormatHolder = new ThreadLocal(){

            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            }
        };

        PerThreadLogFormatter() {
        }

        public static DateFormat getDateFormatter() {
            return dateFormatHolder.get();
        }

        public static class PerThreadFileNameFormatter {
            private static final ThreadLocal<SimpleDateFormat> dateFormatHolder = new ThreadLocal(){

                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                }
            };

            public static DateFormat getDateFormatter() {
                return dateFormatHolder.get();
            }
        }
    }

    private class MainServerCommander {
        private Map<String, commandParser> supportedCommands = new HashMap<String, commandParser>();

        private MainServerCommander() {
        }

        private void checkServerCommand(PrivateMessage message) {
            if (message.getFriendnickname().equalsIgnoreCase(message.getNickname())) {
                return;
            }
            String replyBody = "Unknown command, accepted commands are: " + this.getSupportedCommands();
            String[] split = message.getMessagetext().split(" ");
            if (split.length > 1 && this.supportedCommands.containsKey(split[0])) {
                replyBody = this.supportedCommands.get(split[0]).parseCommandLine(message.getFriendnickname(), message.getMessagetext());
            }
            PrivateMessage reply = new PrivateMessage("SERVER", message.getNickname(), replyBody);
            MainServer.this.clientHandler.sendTo(message.getFriendnickname(), reply);
        }

        private String getSupportedCommands() {
            StringBuilder sb = new StringBuilder();
            for (String keyword : this.supportedCommands.keySet()) {
                sb.append(keyword + ", ");
            }
            String result = sb.toString().trim();
            return "BAN, HELP, KICK, PING, WHOAMI";
        }

        public void addCommand(String keyword, commandParser listener) {
            this.supportedCommands.put(keyword, listener);
        }

        public void removeCommand(String keyword) {
            this.supportedCommands.remove(keyword);
        }
    }

    private final class ClientInstantiator
    implements Runnable {
        private final Socket newClient;

        private ClientInstantiator(Socket newClient) {
            this.newClient = newClient;
        }

        @Override
        public void run() {
            MainServer.this.log("New client connecting from: " + this.newClient.getInetAddress().getCanonicalHostName());
            new Client(MainServer.this.clientHandler, this.newClient);
        }
    }

    private final class ClientCloser
    implements Runnable {
        private Client client;

        public ClientCloser(Client client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.shutdown();
        }
    }

    private final class ClientHandlerImpl
    implements ClientHandler {
        private Map<String, Client> map = new ConcurrentHashMap<String, Client>();

        private ClientHandlerImpl() {
        }

        @Override
        public void unRegisterClient(String nick) {
            if (this.map.containsKey(nick.toLowerCase())) {
                Client client = this.map.remove(nick.toLowerCase());
                this.sendToAllExcept(nick, new LogoutMessage(nick));
                MainServer.this.log("Removing client: " + client);
                System.out.println("User disconnected: " + nick);
            }
        }

        @Override
        public void shutdownClients() {
            for (Client client : this.map.values()) {
                MainServer.this.threadPool.execute(new ClientCloser(client));
                MainServer.this.log("Shutting down client: " + client);
            }
        }

        @Override
        public boolean registerClient(String nick, Client client) {
            MainServer.this.log("User logon request: " + nick + " from " + client.getSocketInetAddress());
            if (nick.equalsIgnoreCase("SERVER")) {
                MainServer.this.log("Won't Register:" + nick.toLowerCase());
                return false;
            }
            if (this.map.containsKey(nick.toLowerCase())) {
                Client old = this.map.get(nick.toLowerCase());
                PrivateMessage message = new PrivateMessage("SERVER", nick, "User logon request from " + client.getSocketInetAddress() + " with your nickname");
                old.sendMessage(message);
                if (this.map.containsKey(nick.toLowerCase())) {
                    MainServer.this.log("Won't Register:" + nick.toLowerCase());
                    return false;
                }
            }
            MainServer.this.log("Registering: " + nick.toLowerCase());
            System.out.println("User connected: " + nick);
            client.startLog(nick.toLowerCase());
            this.map.put(nick.toLowerCase(), client);
            this.sendToAllExcept(nick.toLowerCase(), new FriendMessage(nick, client.getFullName(), client.getIpaddress(), client.getImage()));
            for (Map.Entry<String, Client> entry : this.map.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(nick)) continue;
                Client entryClient = entry.getValue();
                client.sendMessage(new FriendMessage(entryClient.getNickname(), entryClient.getFullName(), entryClient.getIpaddress(), entryClient.getImage()));
            }
            return true;
        }

        @Override
        public void sendTo(String nick, Message message) {
            if (this.map.containsKey(nick.toLowerCase())) {
                this.map.get(nick.toLowerCase()).sendMessage(message);
            } else if (nick.equalsIgnoreCase("SERVER") && message.getType() == 4) {
                MainServer.this.serverCommander.checkServerCommand((PrivateMessage)message);
            }
        }

        @Override
        public boolean sendToAll(Message message) {
            return this.sendToAllExcept("", message);
        }

        @Override
        public boolean sendToAllExcept(String nick, Message message) {
            for (Map.Entry<String, Client> entry : this.map.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(nick)) continue;
                entry.getValue().sendMessage(message);
            }
            return true;
        }

        @Override
        public void addToExecutor(Runnable runnable) {
            MainServer.this.threadPool.execute(runnable);
        }

        @Override
        public boolean getFileLog() {
            return MainServer.this.fileLog;
        }

        @Override
        public String getLogFolder() {
            return DEFAULT_LOG_FOLDER;
        }

        @Override
        public void logError(Client client, String string) {
            MainServer.this.log("Error in client:" + string);
        }

        public int size() {
            return this.map.size();
        }

        @Override
        public void recordStatistics(String type, int value) {
            String str = type;
            switch (str.hashCode()) {
                case 2090922: {
                    if (!str.equals("DATA")) break;
                    MainServer.this.incrementData(value);
                }
            }
        }

        @Override
        public void recordStatistics(String type, String value) {
        }
    }
}

