/*
 * Decompiled with CFR 0.152.
 */
package se.miun.vickar.dt007g.chatserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;

public class DisplayServer
extends Thread {
    ServerSocket ss;
    String httpResourceStart = "HTTP/1.1 200 OK\nContent-Type: ";
    String httpResourceCont = "; charset=UTF-8\nConnection: close\nContent-Length: ";
    private DisplayProvider defaultProvider;
    private Map<String, DisplayResourceProvider> resourceProvider;

    public DisplayServer(int port, DisplayProvider provider) {
        this.defaultProvider = provider;
        while (port < 65536) {
            try {
                this.ss = new ServerSocket(port++);
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    public int getPort() {
        return this.ss.getLocalPort();
    }

    @Override
    public String toString() {
        return "DisplayServer running on:" + this.ss.getLocalPort();
    }

    public void shutdown() {
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.defaultProvider.runDisplayServer()) {
            try {
                Socket s = this.ss.accept();
                HandleConnectionThread t = new HandleConnectionThread(s);
                t.start();
            }
            catch (SocketException e) {
                if (e.getMessage().contains("socket closed")) continue;
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDefaultOutput() {
        return this.getOutput(this.defaultProvider.getOutputString(), "text/html");
    }

    private String getOutput(String content, String contentType) {
        StringBuilder finalString = new StringBuilder().append(this.httpResourceStart).append(contentType).append(this.httpResourceCont).append(content.length()).append("\n\n").append(content);
        String outputString = finalString.toString();
        return outputString;
    }

    private String getResourceString(String requestResource) {
        String content = "";
        String type = "text/plain";
        if (this.resourceProvider == null) {
            this.defaultProvider.updateOutputString();
            return this.getDefaultOutput();
        }
        String[] parameters = requestResource.split("\\?");
        if (this.resourceProvider.containsKey(parameters[0])) {
            DisplayResourceProvider displayResourceProvider = this.resourceProvider.get(parameters[0]);
            displayResourceProvider.updateOutputString();
            type = displayResourceProvider.getContentType();
            content = parameters.length > 1 ? displayResourceProvider.getOutputString(parameters[1].split("&")) : displayResourceProvider.getOutputString();
        }
        return this.getOutput(content, type);
    }

    private class HandleConnectionThread
    extends Thread {
        Socket s;

        public HandleConnectionThread(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                String outputString = "";
                BufferedReader br = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                String requestLine = br.readLine();
                outputString = requestLine != null && requestLine.split(" ").length != 3 ? DisplayServer.this.getDefaultOutput() : this.getResourceOutput(requestLine);
                OutputStream os = this.s.getOutputStream();
                os.write(outputString.getBytes());
                os.flush();
                Thread.sleep(500L);
                os.close();
                this.s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String getResourceOutput(String requestLine) {
            String[] splitRequest = requestLine.split(" ");
            String requestType = splitRequest[0];
            String requestResource = splitRequest[1];
            if (requestType.equalsIgnoreCase("GET") || requestType.equalsIgnoreCase("POST")) {
                return DisplayServer.this.getResourceString(requestResource);
            }
            return DisplayServer.this.getDefaultOutput();
        }
    }

    public static interface DisplayResourceProvider
    extends DisplayProvider {
        public String getContentType();

        public String getOutputString(String[] var1);
    }

    public static interface DisplayProvider {
        public boolean runDisplayServer();

        public void updateOutputString();

        public String getOutputString();
    }
}

